create or replace package tbicds.PCK_PATIENT AUTHID CURRENT_USER is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  type RetRefCursor is ref cursor;

  procedure InitialEncounter(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID       in varchar2,
                             po_nInitialEnc      out number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2);

  --get a record set of patients back that match criteria
  procedure GetPatientLookupRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vKey             in varchar2,
                               pi_nSelectedCases   in number,
                               pi_nSearchType      in number,
                               pi_vSearchValue     in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor);

  --gets basic patient demographic data given the patients fx_user_id
  procedure GetPatientIDRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_vKey             in varchar2,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor);

  procedure GetPatientDemographicsRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_vKey             in varchar2,
                                     pi_vPatientID       in varchar2,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2,
                                     rs                  out RetRefCursor);

  procedure InsertPatientDemographics(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      --Patient Table
                                      pi_vKey            in varchar2,
                                      pi_vPatientID      in varchar2,
                                      pi_vEncounterID    in varchar2,
                                      pi_vFirstName      in varchar2,
                                      pi_vMI             in varchar2,
                                      pi_vLastName       in varchar2,
                                      pi_vSponsorSSN     in varchar2,
                                      pi_vSSN            in varchar2,
                                      pi_vGender         in varchar2,
                                      pi_vDateOfBirth    in varchar2,
                                      pi_vProviderID     in varchar2,
                                      pi_vAddress1       in varchar2,
                                      pi_vAddress2       in varchar2,
                                      pi_vCity           in varchar2,
                                      pi_vPostal_Code    in varchar2,
                                      pi_vHomePhone      in varchar2,
                                      pi_vCellPhone      in varchar2,
                                      pi_vWorkPhone      in varchar2,
                                      pi_vEmail          in varchar2,
                                      pi_vStateID        in varchar2,
                                      pi_nCellPhoneMsg   in number,
                                      pi_nEmailMsg       in number,
                                      pi_nCallPreference in number,
                                      po_nStatusCode     out number,
                                      po_vStatusComment  out varchar2);

  procedure UpdatePatientDemographics(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_vKey             in varchar2,
                                      pi_vPatientID       in varchar2,
                                      pi_vFirstName       in varchar2,
                                      pi_vMI              in varchar2,
                                      pi_vLastName        in varchar2,
                                      pi_vSponsorSSN      in varchar2,
                                      pi_vSSN             in varchar2,
                                      pi_vGender          in varchar2,
                                      pi_vDateOfBirth     in varchar2,
                                      pi_vProviderID      in varchar2,
                                      pi_vAddress1        in varchar2,
                                      pi_vAddress2        in varchar2,
                                      pi_vCity            in varchar2,
                                      pi_vPostal_Code     in varchar2,
                                      pi_vHomePhone       in varchar2,
                                      pi_vCellPhone       in varchar2,
                                      pi_vWorkPhone       in varchar2,
                                      pi_vEmail           in varchar2,
                                      pi_vStateID         in varchar2,
                                      pi_nCellPhoneMsg    in number,
                                      pi_nEmailMsg        in number,
                                      pi_nCallPreference  in number,
                                      pi_nPrefLangID      in number,
                                      pi_vPrefLangOther   in varchar2,
                                      pi_nDutyStatusID    in number,
                                      pi_nHandPrefID      in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2);

  procedure GetPatientTreatmentIdRS(pi_vSessionID       in varchar2,
                                    pi_vSessionClientIP in varchar2,
                                    pi_nUserID          in number,
                                    pi_vPatientID       in varchar2,
                                    po_nStatusCode      out number,
                                    po_vStatusComment   out varchar2,
                                    rs                  out RetRefCursor);

  procedure DelIncPatIntakeAssessments(pi_vSessionID       in varchar2,
                                       pi_vSessionClientIP in varchar2,
                                       pi_nUserID          in number,
                                       pi_vPatientID       in varchar2,
                                       po_nStatusCode      out number,
                                       po_vStatusComment   out varchar2);

  procedure IncPatIntakeAssessments(pi_vSessionID            in varchar2,
                                    pi_vSessionClientIP      in varchar2,
                                    pi_nUserID               in number,
                                    pi_vPatientID            in varchar2,
                                    po_nHasIncPatAssessments out number,
                                    po_nStatusCode           out number,
                                    po_vStatusComment        out varchar2); 

  procedure DeletePatientAssignedModule(pi_vPatientID     in varchar2,
                                        nMID              in number,
                                        po_nStatusCode    out number,
                                        po_vStatusComment out varchar2);    

  --gets dataset to populate Patient Portal Lookup List
  procedure GetPatientPortalListRS(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vKey             in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2,
                                   rs                  out Pck_Utl_Common.refCursor);

  procedure updatePatFxUserRights;

  procedure GetPatientSocioeconomicsRS(pi_vSessionID       in varchar2,
                                       pi_vSessionClientIP in varchar2,
                                       pi_nUserID          in number,
                                       pi_vKey             in varchar2,
                                       pi_vPatientID       in varchar2,
                                       po_nStatusCode      out number,
                                       po_vStatusComment   out varchar2,
                                       rs                  out RetRefCursor);

  procedure UpdatePatientSocioeconomics(pi_vSessionID             in varchar2,
                                        pi_vSessionClientIP       in varchar2,
                                        pi_nUserID                in number,
                                        pi_vKey                   in varchar2,
                                        pi_vPatientID             in varchar2,
                                        pi_nHighestGradeID        in number,
                                        pi_nHighestDegreeID       in number,
                                        pi_nMaritalStatusID       in number,
                                        pi_nEmploymentStatusID    in number,
                                        pi_nJobClassificationID   in number,
                                        pi_vEmploymentStatusOther in varchar2,
                                        po_nStatusCode            out number,
                                        po_vStatusComment         out varchar2);

  procedure InsertPatientSocioeconomics(pi_vSessionID             in varchar2,
                                        pi_vSessionClientIP       in varchar2,
                                        pi_nUserID                in number,
                                        pi_vKey                   in varchar2,
                                        pi_vPatientID             in varchar2,
                                        pi_nHighestGradeID        in number,
                                        pi_nHighestDegreeID       in number,
                                        pi_nMaritalStatusID       in number,
                                        pi_nEmploymentStatusID    in number,
                                        pi_nJobClassificationID   in number,
                                        pi_vEmploymentStatusOther in varchar2,
                                        po_nStatusCode            out number,
                                        po_vStatusComment         out varchar2);

end;
/

